/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.web.search.utils;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Iterator;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.eclipse.epf.web.search.utils.StrUtil;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXParseException;

public class XMLUtil {
    public static final String XML_DECLARATION = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>";
    public static final String XML_AMP = "&amp;";
    public static final String XML_APOS = "&apos;";
    public static final String XML_CR = "&#13;";
    public static final String XML_GT = "&gt;";
    public static final String XML_LT = "&lt;";
    public static final String XML_LF = "&#10;";
    public static final String XML_QUOT = "&quot;";
    public static final String XML_TAB = "&#9;";
    private static final String CRLF = "\r\n";
    private static final byte[] CRLF_BYTES = "\r\n".getBytes();

    private XMLUtil() {
    }

    public static Node cloneNode(Node node, Document doc) {
        Node clone = null;
        switch (node.getNodeType()) {
            case 1: {
                clone = doc.createElement(node.getNodeName());
                NamedNodeMap attrs = node.getAttributes();
                int i = 0;
                while (i < attrs.getLength()) {
                    Node attrNode = attrs.item(i);
                    Attr attrClone = doc.createAttribute(attrNode.getNodeName());
                    attrClone.setNodeValue(attrNode.getNodeValue());
                    ((Element)clone).setAttributeNode(attrClone);
                    ++i;
                }
                NodeList childNodes = node.getChildNodes();
                if (childNodes == null) break;
                int i2 = 0;
                while (i2 < childNodes.getLength()) {
                    Node childNode = childNodes.item(i2);
                    Node childClone = XMLUtil.cloneNode(childNode, doc);
                    clone.appendChild(childClone);
                    ++i2;
                }
                break;
            }
            case 3: 
            case 4: {
                clone = doc.createTextNode(node.getNodeName());
                clone.setNodeValue(node.getNodeValue());
            }
        }
        return clone;
    }

    public static String escape(String str) {
        if (str == null || str.length() == 0) {
            return "";
        }
        StringBuffer sb = new StringBuffer();
        int len = str.length();
        int i = 0;
        while (i < len) {
            char ch = str.charAt(i);
            switch (ch) {
                case '<': {
                    sb.append(XML_LT);
                    break;
                }
                case '>': {
                    sb.append(XML_GT);
                    break;
                }
                case '&': {
                    sb.append(XML_AMP);
                    break;
                }
                case '\"': {
                    sb.append(XML_QUOT);
                    break;
                }
                case '\'': {
                    sb.append(XML_APOS);
                    break;
                }
                case '\r': {
                    sb.append(XML_CR);
                    break;
                }
                case '\n': {
                    sb.append(XML_LF);
                    break;
                }
                default: {
                    sb.append(ch);
                }
            }
            ++i;
        }
        return sb.toString();
    }

    public static String escape(String str, boolean ignoreCRLF) {
        if (str == null || str.length() == 0) {
            return "";
        }
        StringBuffer sb = new StringBuffer();
        int len = str.length();
        int i = 0;
        while (i < len) {
            char ch = str.charAt(i);
            switch (ch) {
                case '<': {
                    sb.append(XML_LT);
                    break;
                }
                case '>': {
                    sb.append(XML_GT);
                    break;
                }
                case '&': {
                    sb.append(XML_AMP);
                    break;
                }
                case '\"': {
                    sb.append(XML_QUOT);
                    break;
                }
                case '\'': {
                    sb.append(XML_APOS);
                    break;
                }
                case '\r': {
                    if (ignoreCRLF) {
                        sb.append(ch);
                        break;
                    }
                    sb.append(XML_CR);
                    break;
                }
                case '\n': {
                    if (ignoreCRLF) {
                        sb.append(ch);
                        break;
                    }
                    sb.append(XML_LF);
                    break;
                }
                default: {
                    sb.append(ch);
                }
            }
            ++i;
        }
        return sb.toString();
    }

    public static String unescape(String str) {
        if (str == null || str.length() == 0) {
            return "";
        }
        StringBuffer sb = new StringBuffer();
        int len = str.length();
        int i = 0;
        while (i < len) {
            char ch = str.charAt(i);
            switch (ch) {
                case '&': {
                    if (str.startsWith(XML_LT, i)) {
                        sb.append('<');
                        i += 3;
                        break;
                    }
                    if (str.startsWith(XML_GT, i)) {
                        sb.append('>');
                        i += 3;
                        break;
                    }
                    if (str.startsWith(XML_AMP, i)) {
                        sb.append('&');
                        i += 4;
                        break;
                    }
                    if (str.startsWith(XML_QUOT, i)) {
                        sb.append('\"');
                        i += 5;
                        break;
                    }
                    if (str.startsWith(XML_APOS, i)) {
                        sb.append("'");
                        i += 5;
                        break;
                    }
                    if (str.startsWith(XML_CR, i)) {
                        sb.append('\r');
                        i += 4;
                        break;
                    }
                    if (str.startsWith(XML_LF, i)) {
                        sb.append('\n');
                        i += 4;
                        break;
                    }
                    sb.append(ch);
                    break;
                }
                default: {
                    sb.append(ch);
                }
            }
            ++i;
        }
        return sb.toString();
    }

    public static void writeDocument(Document xmlDoc, OutputStream output) throws IOException {
        DataOutputStream out = new DataOutputStream(output);
        XMLUtil.writeNode(xmlDoc, "", out);
        out.flush();
    }

    public static void writeDocument(Document xmlDoc, PrintWriter pw) throws IOException {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        DataOutputStream out = new DataOutputStream(os);
        XMLUtil.writeNode(xmlDoc, "", out);
        out.flush();
        String s = os.toString();
        pw.write(s);
        pw.flush();
    }

    public static void saveDocument(Document xmlDoc, String xmlFile) throws IOException {
        DataOutputStream out = new DataOutputStream(new FileOutputStream(xmlFile));
        XMLUtil.writeNode(xmlDoc, "", out);
        out.flush();
        out.close();
    }

    public static void saveDocument(String xmlStr, String xmlFile) throws IOException {
        DataOutputStream out = new DataOutputStream(new FileOutputStream(xmlFile));
        out.write(xmlStr.getBytes());
        out.flush();
        out.close();
    }

    private static void writeNode(Node node, String indent, DataOutputStream out) throws IOException {
        switch (node.getNodeType()) {
            case 9: {
                out.write(StrUtil.getUTF8Bytes(XML_DECLARATION));
                out.write(CRLF_BYTES);
                NodeList nodes = node.getChildNodes();
                if (nodes == null) break;
                int i = 0;
                while (i < nodes.getLength()) {
                    XMLUtil.writeNode(nodes.item(i), "", out);
                    ++i;
                }
                break;
            }
            case 1: {
                String name = node.getNodeName();
                out.write(StrUtil.getUTF8Bytes(String.valueOf(indent) + "<" + name));
                NamedNodeMap attrs = node.getAttributes();
                int i = 0;
                while (i < attrs.getLength()) {
                    Node attrNode = attrs.item(i);
                    out.write(StrUtil.getUTF8Bytes(" " + attrNode.getNodeName() + "=\"" + XMLUtil.escape(attrNode.getNodeValue()) + "\""));
                    ++i;
                }
                out.write(StrUtil.getUTF8Bytes(">"));
                out.write(CRLF_BYTES);
                NodeList childNodes = node.getChildNodes();
                if (childNodes != null) {
                    int i2 = 0;
                    while (i2 < childNodes.getLength()) {
                        XMLUtil.writeNode(childNodes.item(i2), indent, out);
                        ++i2;
                    }
                }
                out.write(StrUtil.getUTF8Bytes(String.valueOf(indent) + "</" + name + ">"));
                out.write(CRLF_BYTES);
                break;
            }
            case 3: {
                String text = StrUtil.removeWhiteSpaceChars(node.getNodeValue());
                if (text.length() <= 0) break;
                out.write(StrUtil.getUTF8Bytes(XMLUtil.escape(text)));
                break;
            }
            case 4: {
                String text = StrUtil.removeWhiteSpaceChars(node.getNodeValue());
                if (text.length() <= 0) break;
                out.write(StrUtil.getUTF8Bytes("<![CDATA["));
                out.write(StrUtil.getUTF8Bytes(text));
                out.write(StrUtil.getUTF8Bytes("]]>"));
                out.write(CRLF_BYTES);
                break;
            }
            case 7: {
                out.write(StrUtil.getUTF8Bytes("<?" + node.getNodeName() + " " + node.getNodeValue() + "?>"));
                out.write(CRLF_BYTES);
                break;
            }
            case 5: {
                out.write(StrUtil.getUTF8Bytes("&" + node.getNodeName() + ";"));
            }
        }
    }

    public static String getLocationOfException(SAXParseException e) {
        StringBuffer sb = new StringBuffer();
        sb.append("row ");
        sb.append(e.getLineNumber());
        sb.append(", col ");
        sb.append(e.getColumnNumber());
        String systemId = e.getSystemId();
        if (systemId != null) {
            int index = systemId.lastIndexOf(47);
            if (index != -1) {
                systemId = systemId.substring(index + 1);
            }
            sb.append(" of XML document ");
            sb.append(systemId);
        }
        return sb.toString();
    }

    public static Document loadXml(File file) throws Exception {
        DocumentBuilderFactory builderFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = builderFactory.newDocumentBuilder();
        return builder.parse(file);
    }

    public static Document createDocument() throws Exception {
        DocumentBuilderFactory builderFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = builderFactory.newDocumentBuilder();
        return builder.newDocument();
    }

    public static String getNodeText(Element tag) {
        String text = tag.toString();
        int i = text.indexOf(">");
        int j = text.lastIndexOf("</");
        if (i < 0 || j < 0 || j < i) {
            return "";
        }
        return text.substring(i + 1, j);
    }

    public static String getChildText(Element tag, String childTagName) {
        Element child = XMLUtil.getFirstChild(tag, childTagName);
        if (child != null) {
            return XMLUtil.getNodeText(child);
        }
        return "";
    }

    public static Element getFirstChild(Element tag, String childTagName) {
        NodeList nodes = tag.getElementsByTagName(childTagName);
        if (nodes == null || nodes.getLength() == 0) {
            return null;
        }
        return (Element)nodes.item(0);
    }

    public static Iterator childIterator(Element tag) {
        NodeList nodes = tag.getChildNodes();
        ArrayList<Node> elements = new ArrayList<Node>();
        if (nodes != null) {
            int size = nodes.getLength();
            int i = 0;
            while (i < size) {
                Node node = nodes.item(i);
                if (node instanceof Element) {
                    elements.add(node);
                }
                ++i;
            }
        }
        return elements.iterator();
    }

    public static Iterator childIterator(Element tag, String childTagName) {
        NodeList nodes = tag.getElementsByTagName(childTagName);
        return new NodeIterator(nodes);
    }

    private static class NodeIterator
    implements Iterator {
        int currentIndex = -1;
        int size = 0;
        NodeList nodes = null;

        public NodeIterator(NodeList nodes) {
            this.nodes = nodes;
            if (nodes != null) {
                this.size = nodes.getLength();
            }
        }

        public void remove() {
        }

        public boolean hasNext() {
            return this.currentIndex + 1 < this.size;
        }

        public Object next() {
            if (this.hasNext()) {
                return this.nodes.item(++this.currentIndex);
            }
            return null;
        }
    }
}

